import { world, system, EquipmentSlot, TicksPerSecond } from '@minecraft/server'

system.runInterval(() => {
    world.getAllPlayers().filter(
        (data) => {
            const playerEquipment = data.getComponent("equippable");
            if (
                playerEquipment.getEquipment(EquipmentSlot.Head)?.typeId == 'v360:emerald_helmet'
                && playerEquipment.getEquipment(EquipmentSlot.Chest)?.typeId == 'v360:emerald_chestplate'
                && playerEquipment.getEquipment(EquipmentSlot.Legs)?.typeId == 'v360:emerald_leggings'
                && playerEquipment.getEquipment(EquipmentSlot.Feet)?.typeId == 'v360:emerald_boots'
            ) {
                data.addEffect("health_boost", TicksPerSecond * 1, { amplifier: 4, showParticles: false })
            }
        }
    )
})